/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UserManagement {
    private HashMap<String, String> users = new HashMap();
    private File userFile = new File("um.oszuser");
    private String password = "v$Eez6!BX&cA3ZJ%Ztw87%MwbpbsAkjz2PaECW&grSq@DGBHisgjJwC@Kq@R4Ufz";
    private SecureEnclave secureEnclave = new SecureEnclave();
    private FileHandler fileHandler = new FileHandler();

    public UserManagement() {
        this.loadUsers();
    }

    public void addUser(String username, String password) {
        this.users.put(username, password);
        this.saveUsers();
    }

    public void removeUser(String username) {
        this.users.remove(username);
        if (this.users.isEmpty()) {
            try {
                this.fileHandler.deleteFile(this.userFile);
            }
            catch (IOException e) {
                this.handleFileError(e);
            }
        } else {
            this.saveUsers();
        }
    }

    public boolean userExists(String username, String password) {
        String storedPassword = this.users.get(username);
        return storedPassword != null && storedPassword.equals(password);
    }

    private void loadUsers() {
        try {
            byte[] encryptedData = this.fileHandler.readFile(this.userFile);
            String decryptedText = this.secureEnclave.decrypt(this.password, encryptedData);
            this.users = this.hashMapFromString(decryptedText);
        }
        catch (FileNotFoundException e) {
            System.err.println("User file not found: " + this.userFile.getAbsolutePath());
            this.users.clear();
        }
        catch (IOException e) {
            this.handleFileError(e);
        }
        catch (SecurityException e) {
            this.handleDecryptionError(e);
        }
    }

    private void saveUsers() {
        String serializedData = this.hashMapToString(this.users);
        byte[] encryptedData = this.secureEnclave.encrypt(this.password, serializedData);
        try {
            this.fileHandler.writeFile(this.userFile, encryptedData);
        }
        catch (IOException e) {
            this.handleFileError(e);
        }
    }

    private HashMap<String, String> hashMapFromString(String mapString) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (mapString != null) {
            String[] keyValuePairs;
            String[] stringArray = keyValuePairs = mapString.replaceAll("\\{|\\}", "").split(", ");
            int n = keyValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] entry = pair.split("=");
                if (entry.length == 2) {
                    newMap.put(entry[0].trim(), entry[1].trim());
                } else {
                    System.err.println("Invalid format in mapString: " + mapString);
                }
                ++n2;
            }
        }
        return newMap;
    }

    private String hashMapToString(HashMap<String, String> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append(", ");
        }
        if (!hashMap.isEmpty()) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private void handleFileError(IOException e) {
        e.printStackTrace();
    }

    private void handleDecryptionError(SecurityException e) {
        e.printStackTrace();
    }
}

