/*
 * Decompiled with CFR 0.152.
 */
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class SecureEnclave {
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int ITERATION_COUNT = 65536;
    private static final int KEY_LENGTH = 256;

    public byte[] encrypt(String password, String plaintext) {
        try {
            SecureRandom secureRandom = new SecureRandom();
            byte[] salt = new byte[16];
            secureRandom.nextBytes(salt);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 65536, 256);
            SecretKeySpec secretKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            byte[] iv = new byte[cipher.getBlockSize()];
            secureRandom.nextBytes(iv);
            cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
            byte[] encryptedText = cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
            byte[] encryptedData = new byte[salt.length + iv.length + encryptedText.length];
            System.arraycopy(salt, 0, encryptedData, 0, salt.length);
            System.arraycopy(iv, 0, encryptedData, salt.length, iv.length);
            System.arraycopy(encryptedText, 0, encryptedData, salt.length + iv.length, encryptedText.length);
            return encryptedData;
        }
        catch (Exception e) {
            System.out.println("Encryption error: " + e.getMessage());
            return null;
        }
    }

    public String decrypt(String password, byte[] encryptedData) {
        try {
            byte[] salt = Arrays.copyOfRange(encryptedData, 0, 16);
            byte[] iv = Arrays.copyOfRange(encryptedData, 16, 32);
            byte[] encryptedText = Arrays.copyOfRange(encryptedData, 32, encryptedData.length);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 65536, 256);
            SecretKeySpec secretKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            byte[] decryptedText = cipher.doFinal(encryptedText);
            return new String(decryptedText, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            System.out.println("Decryption error: " + e.getMessage());
            return null;
        }
    }
}

