/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class CipherWindow {
    private JFrame frmOszimtcrypter;
    private File encryptedFile;
    private JEditorPane editorPane;
    private String password;
    private String username;
    private UserManagement um = new UserManagement();
    private SecureEnclave se = new SecureEnclave();
    private FileHandler fh = new FileHandler();

    public CipherWindow(String password, String username) {
        this.setPassword(password);
        this.setUsername(username);
        this.initialize();
    }

    private void initialize() {
        this.frmOszimtcrypter = new JFrame();
        this.frmOszimtcrypter.setTitle("OSZimt-Crypter");
        this.frmOszimtcrypter.setBounds(100, 100, 450, 300);
        this.frmOszimtcrypter.setDefaultCloseOperation(0);
        this.frmOszimtcrypter.setMinimumSize(new Dimension(450, 300));
        this.frmOszimtcrypter.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CipherWindow.this.onExit();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.frmOszimtcrypter.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        JMenuItem openItem = new JMenuItem("Open File");
        fileMenu.add(openItem);
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                int result = fileChooser.showOpenDialog(null);
                if (result == 0) {
                    CipherWindow.this.encryptedFile = fileChooser.getSelectedFile();
                }
            }
        });
        JMenuItem saveAsMenuItem = new JMenuItem("Save As");
        fileMenu.add(saveAsMenuItem);
        saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                int returnValue = fileChooser.showSaveDialog(null);
                if (returnValue == 0) {
                    CipherWindow.this.encryptedFile = fileChooser.getSelectedFile();
                }
            }
        });
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        JMenuItem helpLinkItem = new JMenuItem("Help-Wiki");
        helpMenu.add(helpLinkItem);
        helpLinkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URI uri = new URI("http://ita12docoszimt.serveblog.net");
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JMenuItem logOutFromUser = new JMenuItem("Log out from: " + this.getUsername());
        helpMenu.add(logOutFromUser);
        logOutFromUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CipherWindow.this.um.removeUser(CipherWindow.this.getUsername());
                CipherWindow.this.onLogOut();
            }
        });
        JMenuItem deleteUser = new JMenuItem("Log out and delete: " + this.getUsername());
        helpMenu.add(deleteUser);
        deleteUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CipherWindow.this.onLogOut();
                CipherWindow.this.um.removeUser(CipherWindow.this.getUsername());
            }
        });
        JPanel pnl1 = new JPanel();
        pnl1.setLayout(new BorderLayout(0, 0));
        this.frmOszimtcrypter.getContentPane().add(pnl1);
        JPanel pnlbutton = new JPanel();
        pnl1.add((Component)pnlbutton, "South");
        JButton btnNewButton = new JButton("Encrypt");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String plaintext = CipherWindow.this.editorPane.getText();
                byte[] encryptedData = CipherWindow.this.se.encrypt(CipherWindow.this.password, plaintext);
                try {
                    CipherWindow.this.fh.writeFile(CipherWindow.this.encryptedFile, encryptedData);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                CipherWindow.this.editorPane.setText("");
            }
        });
        JButton btnNewButton_1 = new JButton("Decrypt");
        btnNewButton_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    byte[] encryptedData = CipherWindow.this.fh.readFile(CipherWindow.this.encryptedFile);
                    String decryptedText = CipherWindow.this.se.decrypt(CipherWindow.this.password, encryptedData);
                    CipherWindow.this.editorPane.setText(decryptedText);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.editorPane = new JEditorPane();
        pnl1.add((Component)this.editorPane, "Center");
        pnlbutton.add(btnNewButton);
        pnlbutton.add(btnNewButton_1);
        this.encryptedFile = new File(String.valueOf(this.getUsername()) + "_data.oszcryped");
        this.frmOszimtcrypter.setVisible(true);
    }

    public static void main(String[] args) {
        new CipherWindow("fabian66", "mahd");
    }

    public void onExit() {
        String plaintext = this.editorPane.getText();
        byte[] encryptedData = this.se.encrypt(this.password, plaintext);
        try {
            this.fh.writeFile(this.encryptedFile, encryptedData);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.exit(0);
    }

    public void onLogOut() {
        String plaintext = this.editorPane.getText();
        byte[] encryptedData = this.se.encrypt(this.password, plaintext);
        try {
            this.fh.writeFile(this.encryptedFile, encryptedData);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.frmOszimtcrypter.dispose();
        new LoginWindow();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

